@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCodeEditorAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a CodeEditor app. see Custom Image below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class UserProfileUserSettingsCodeEditorAppSettingsArgs(
    public val customImages: Output<List<UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec: Output<UserProfileUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCodeEditorAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCodeEditorAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCodeEditorAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsCodeEditorAppSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsCodeEditorAppSettingsArgsBuilder internal constructor() {
    private var customImages:
        Output<List<UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<UserProfileUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a CodeEditor app. see Custom Image below.
     */
    @JvmName("rxcnnwqvwmniphqf")
    public suspend fun customImages(`value`: Output<List<UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("ltuxdbgclinllbea")
    public suspend fun customImages(vararg values: Output<UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgs>) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a CodeEditor app. see Custom Image below.
     */
    @JvmName("uofjkmhpbstlorla")
    public suspend fun customImages(values: List<Output<UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("lslpuegprbrnwvwn")
    public suspend fun defaultResourceSpec(`value`: Output<UserProfileUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("xjexrnajinvsqcpn")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("fphxwianpkxnqegb")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("okdexxgosatidviv")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a CodeEditor app. see Custom Image below.
     */
    @JvmName("lcbqmkssnfspjlgl")
    public suspend fun customImages(`value`: List<UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a CodeEditor app. see Custom Image below.
     */
    @JvmName("jfglbmlxdbmvwsos")
    public suspend fun customImages(argument: List<suspend UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a CodeEditor app. see Custom Image below.
     */
    @JvmName("gibtirkdasbqsygw")
    public suspend fun customImages(vararg argument: suspend UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a CodeEditor app. see Custom Image below.
     */
    @JvmName("aiyjpdqgcfubmnis")
    public suspend fun customImages(argument: suspend UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a CodeEditor app. see Custom Image below.
     */
    @JvmName("ttladytextldjtbm")
    public suspend fun customImages(vararg values: UserProfileUserSettingsCodeEditorAppSettingsCustomImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("xcgaglgcohmrbydo")
    public suspend fun defaultResourceSpec(`value`: UserProfileUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("ycsjuecugxknevcw")
    public suspend fun defaultResourceSpec(argument: suspend UserProfileUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("tyetaoaxudocnohe")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("vwthpvlfyhucbmjt")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): UserProfileUserSettingsCodeEditorAppSettingsArgs =
        UserProfileUserSettingsCodeEditorAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
