@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCustomFileSystemConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property efsFileSystemConfigs The default EBS storage settings for a private space. See EFS File System Config below.
 */
public data class UserProfileUserSettingsCustomFileSystemConfigArgs(
    public val efsFileSystemConfigs: Output<List<UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCustomFileSystemConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCustomFileSystemConfigArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCustomFileSystemConfigArgs.builder()
            .efsFileSystemConfigs(
                efsFileSystemConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsCustomFileSystemConfigArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsCustomFileSystemConfigArgsBuilder internal constructor() {
    private var efsFileSystemConfigs:
        Output<List<UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs>>? = null

    /**
     * @param value The default EBS storage settings for a private space. See EFS File System Config below.
     */
    @JvmName("obgltwsshqtfhxcc")
    public suspend fun efsFileSystemConfigs(`value`: Output<List<UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs>>) {
        this.efsFileSystemConfigs = value
    }

    @JvmName("wgirvlyfxganxefj")
    public suspend fun efsFileSystemConfigs(vararg values: Output<UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs>) {
        this.efsFileSystemConfigs = Output.all(values.asList())
    }

    /**
     * @param values The default EBS storage settings for a private space. See EFS File System Config below.
     */
    @JvmName("iuocgvirbebbwnqw")
    public suspend fun efsFileSystemConfigs(values: List<Output<UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs>>) {
        this.efsFileSystemConfigs = Output.all(values)
    }

    /**
     * @param value The default EBS storage settings for a private space. See EFS File System Config below.
     */
    @JvmName("oipwrpvxcubwpuij")
    public suspend fun efsFileSystemConfigs(`value`: List<UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efsFileSystemConfigs = mapped
    }

    /**
     * @param argument The default EBS storage settings for a private space. See EFS File System Config below.
     */
    @JvmName("wtecvgrrwomkhmcn")
    public suspend fun efsFileSystemConfigs(argument: List<suspend UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.efsFileSystemConfigs = mapped
    }

    /**
     * @param argument The default EBS storage settings for a private space. See EFS File System Config below.
     */
    @JvmName("kilkxjyjfnidgybo")
    public suspend fun efsFileSystemConfigs(vararg argument: suspend UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.efsFileSystemConfigs = mapped
    }

    /**
     * @param argument The default EBS storage settings for a private space. See EFS File System Config below.
     */
    @JvmName("wqcgyyllglhbfqpj")
    public suspend fun efsFileSystemConfigs(argument: suspend UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.efsFileSystemConfigs = mapped
    }

    /**
     * @param values The default EBS storage settings for a private space. See EFS File System Config below.
     */
    @JvmName("hadmpfudoavvvppt")
    public suspend fun efsFileSystemConfigs(vararg values: UserProfileUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.efsFileSystemConfigs = mapped
    }

    internal fun build(): UserProfileUserSettingsCustomFileSystemConfigArgs =
        UserProfileUserSettingsCustomFileSystemConfigArgs(
            efsFileSystemConfigs = efsFileSystemConfigs,
        )
}
