@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
 * @property customImages
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class UserProfileUserSettingsJupyterLabAppSettingsArgs(
    public val codeRepositories: Output<List<UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>>? = null,
    public val customImages: Output<List<UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec: Output<UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsArgs.builder()
            .codeRepositories(
                codeRepositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsJupyterLabAppSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsJupyterLabAppSettingsArgsBuilder internal constructor() {
    private var codeRepositories:
        Output<List<UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>>? = null

    private var customImages:
        Output<List<UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("mawfrilqbegruean")
    public suspend fun codeRepositories(`value`: Output<List<UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = value
    }

    @JvmName("vfjwnqyqfickoxjf")
    public suspend fun codeRepositories(vararg values: Output<UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>) {
        this.codeRepositories = Output.all(values.asList())
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("kxabpupiladsawwv")
    public suspend fun codeRepositories(values: List<Output<UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("krbysspclwaefltt")
    public suspend fun customImages(`value`: Output<List<UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("mqeqdegcxvsmaswe")
    public suspend fun customImages(vararg values: Output<UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs>) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("swgvakwobqfmirlu")
    public suspend fun customImages(values: List<Output<UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("bnyhidfbuovvkuhs")
    public suspend fun defaultResourceSpec(`value`: Output<UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("isykqrnqrgexwcxl")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("tumjsihpatgnmmgh")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("wpnygbgonvrywflf")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("wvxbxuujnxarjwjh")
    public suspend fun codeRepositories(`value`: List<UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("jexbiqawhsionhle")
    public suspend fun codeRepositories(argument: List<suspend UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("dqyxswdgxqmjmtbh")
    public suspend fun codeRepositories(vararg argument: suspend UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("pfujdkxklaoigkfs")
    public suspend fun codeRepositories(argument: suspend UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("cwbxogytcsncilun")
    public suspend fun codeRepositories(vararg values: UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param value
     */
    @JvmName("mfkhxbdobktiyctp")
    public suspend fun customImages(`value`: List<UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("radcjqcyvpwlnljk")
    public suspend fun customImages(argument: List<suspend UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ibewtwwwwtebbale")
    public suspend fun customImages(vararg argument: suspend UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mflegjilmotyxqfi")
    public suspend fun customImages(argument: suspend UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values
     */
    @JvmName("thixkbnnnbowiawa")
    public suspend fun customImages(vararg values: UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("juabslrolmiypkjr")
    public suspend fun defaultResourceSpec(`value`: UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("rfvpgngbkyvbamfc")
    public suspend fun defaultResourceSpec(argument: suspend UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("apxvbpyyqwxuqafr")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("gjubbcejrjellysv")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): UserProfileUserSettingsJupyterLabAppSettingsArgs =
        UserProfileUserSettingsJupyterLabAppSettingsArgs(
            codeRepositories = codeRepositories,
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
