@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property repositoryUrl The URL of the Git repository.
 */
public data class UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs(
    public val repositoryUrl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs.builder()
            .repositoryUrl(repositoryUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder internal constructor() {
    private var repositoryUrl: Output<String>? = null

    /**
     * @param value The URL of the Git repository.
     */
    @JvmName("swuggetftcosttnr")
    public suspend fun repositoryUrl(`value`: Output<String>) {
        this.repositoryUrl = value
    }

    /**
     * @param value The URL of the Git repository.
     */
    @JvmName("aebxrfvbnttnrmpe")
    public suspend fun repositoryUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryUrl = mapped
    }

    internal fun build(): UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs =
        UserProfileUserSettingsJupyterLabAppSettingsCodeRepositoryArgs(
            repositoryUrl = repositoryUrl ?: throw PulumiNullFieldException("repositoryUrl"),
        )
}
