@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appImageConfigName The name of the App Image Config.
 * @property imageName The name of the Custom Image.
 * @property imageVersionNumber The version number of the Custom Image.
 */
public data class UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs(
    public val appImageConfigName: Output<String>,
    public val imageName: Output<String>,
    public val imageVersionNumber: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs.builder()
            .appImageConfigName(appImageConfigName.applyValue({ args0 -> args0 }))
            .imageName(imageName.applyValue({ args0 -> args0 }))
            .imageVersionNumber(imageVersionNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder internal constructor() {
    private var appImageConfigName: Output<String>? = null

    private var imageName: Output<String>? = null

    private var imageVersionNumber: Output<Int>? = null

    /**
     * @param value The name of the App Image Config.
     */
    @JvmName("yfnapfjfagcbnqrg")
    public suspend fun appImageConfigName(`value`: Output<String>) {
        this.appImageConfigName = value
    }

    /**
     * @param value The name of the Custom Image.
     */
    @JvmName("qhykwujvojqxbcfk")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value The version number of the Custom Image.
     */
    @JvmName("oodevblmpkdgjfkl")
    public suspend fun imageVersionNumber(`value`: Output<Int>) {
        this.imageVersionNumber = value
    }

    /**
     * @param value The name of the App Image Config.
     */
    @JvmName("rkmiurlubwiufera")
    public suspend fun appImageConfigName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appImageConfigName = mapped
    }

    /**
     * @param value The name of the Custom Image.
     */
    @JvmName("hqnxqbentpovhnsa")
    public suspend fun imageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value The version number of the Custom Image.
     */
    @JvmName("vyviawrbaearbhqt")
    public suspend fun imageVersionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageVersionNumber = mapped
    }

    internal fun build(): UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs =
        UserProfileUserSettingsJupyterLabAppSettingsCustomImageArgs(
            appImageConfigName = appImageConfigName ?: throw PulumiNullFieldException("appImageConfigName"),
            imageName = imageName ?: throw PulumiNullFieldException("imageName"),
            imageVersionNumber = imageVersionNumber,
        )
}
