@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
 * @property lifecycleConfigArn The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
 * @property sagemakerImageArn The ARN of the SageMaker image that the image version belongs to.
 * @property sagemakerImageVersionAlias The SageMaker Image Version Alias.
 * @property sagemakerImageVersionArn The ARN of the image version created on the instance.
 */
public data class UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs(
    public val instanceType: Output<String>? = null,
    public val lifecycleConfigArn: Output<String>? = null,
    public val sagemakerImageArn: Output<String>? = null,
    public val sagemakerImageVersionAlias: Output<String>? = null,
    public val sagemakerImageVersionArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs.builder()
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .lifecycleConfigArn(lifecycleConfigArn?.applyValue({ args0 -> args0 }))
            .sagemakerImageArn(sagemakerImageArn?.applyValue({ args0 -> args0 }))
            .sagemakerImageVersionAlias(sagemakerImageVersionAlias?.applyValue({ args0 -> args0 }))
            .sagemakerImageVersionArn(sagemakerImageVersionArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var lifecycleConfigArn: Output<String>? = null

    private var sagemakerImageArn: Output<String>? = null

    private var sagemakerImageVersionAlias: Output<String>? = null

    private var sagemakerImageVersionArn: Output<String>? = null

    /**
     * @param value The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
     */
    @JvmName("pevigtbeoaoncfjf")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    @JvmName("ddgdabubvdegfjon")
    public suspend fun lifecycleConfigArn(`value`: Output<String>) {
        this.lifecycleConfigArn = value
    }

    /**
     * @param value The ARN of the SageMaker image that the image version belongs to.
     */
    @JvmName("xjtuuxplwaiqixtx")
    public suspend fun sagemakerImageArn(`value`: Output<String>) {
        this.sagemakerImageArn = value
    }

    /**
     * @param value The SageMaker Image Version Alias.
     */
    @JvmName("gdcqdamypojhiloi")
    public suspend fun sagemakerImageVersionAlias(`value`: Output<String>) {
        this.sagemakerImageVersionAlias = value
    }

    /**
     * @param value The ARN of the image version created on the instance.
     */
    @JvmName("bfskbxpmvdhtbpbb")
    public suspend fun sagemakerImageVersionArn(`value`: Output<String>) {
        this.sagemakerImageVersionArn = value
    }

    /**
     * @param value The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
     */
    @JvmName("udjnyeetmaphsmpm")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    @JvmName("vhthgpclntqbhswb")
    public suspend fun lifecycleConfigArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArn = mapped
    }

    /**
     * @param value The ARN of the SageMaker image that the image version belongs to.
     */
    @JvmName("ojhbgseuwmdudxsu")
    public suspend fun sagemakerImageArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageArn = mapped
    }

    /**
     * @param value The SageMaker Image Version Alias.
     */
    @JvmName("uwfgnyaqnhvbahxi")
    public suspend fun sagemakerImageVersionAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageVersionAlias = mapped
    }

    /**
     * @param value The ARN of the image version created on the instance.
     */
    @JvmName("ksgiblpsnvrkpjmy")
    public suspend fun sagemakerImageVersionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageVersionArn = mapped
    }

    internal fun build(): UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs =
        UserProfileUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs(
            instanceType = instanceType,
            lifecycleConfigArn = lifecycleConfigArn,
            sagemakerImageArn = sagemakerImageArn,
            sagemakerImageVersionAlias = sagemakerImageVersionAlias,
            sagemakerImageVersionArn = sagemakerImageVersionArn,
        )
}
