@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterServerAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class UserProfileUserSettingsJupyterServerAppSettingsArgs(
    public val codeRepositories: Output<List<UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>>? = null,
    public val defaultResourceSpec: Output<UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterServerAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterServerAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterServerAppSettingsArgs.builder()
            .codeRepositories(
                codeRepositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsJupyterServerAppSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsJupyterServerAppSettingsArgsBuilder internal constructor() {
    private var codeRepositories:
        Output<List<UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>>? = null

    private var defaultResourceSpec:
        Output<UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("myqefbjmhkkyuvgu")
    public suspend fun codeRepositories(`value`: Output<List<UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = value
    }

    @JvmName("yslkgxpmhijprwge")
    public suspend fun codeRepositories(vararg values: Output<UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>) {
        this.codeRepositories = Output.all(values.asList())
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("anvrgysuksuegyvn")
    public suspend fun codeRepositories(values: List<Output<UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("chdoinlnhyrhlhrx")
    public suspend fun defaultResourceSpec(`value`: Output<UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("ppbytopefqsbaqao")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("vefuyuoyhryweelc")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("clqvyytkyapljvhc")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("ibopuvjwbgvsbppy")
    public suspend fun codeRepositories(`value`: List<UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("awdfglxxyirbimko")
    public suspend fun codeRepositories(argument: List<suspend UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("nvpvvxbyknxyqjvf")
    public suspend fun codeRepositories(vararg argument: suspend UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("ctdwyyasfjgakdbq")
    public suspend fun codeRepositories(argument: suspend UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see Code Repository below.
     */
    @JvmName("bexbmjgjaybvmlro")
    public suspend fun codeRepositories(vararg values: UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("dqtlcifvibkojsah")
    public suspend fun defaultResourceSpec(`value`: UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("swkwsdsuagslsolx")
    public suspend fun defaultResourceSpec(argument: suspend UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("wyedhebakufmetnf")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("jjsciretnrvdjmus")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): UserProfileUserSettingsJupyterServerAppSettingsArgs =
        UserProfileUserSettingsJupyterServerAppSettingsArgs(
            codeRepositories = codeRepositories,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
