@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property repositoryUrl The URL of the Git repository.
 */
public data class UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs(
    public val repositoryUrl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs.builder()
            .repositoryUrl(repositoryUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder internal constructor() {
    private var repositoryUrl: Output<String>? = null

    /**
     * @param value The URL of the Git repository.
     */
    @JvmName("mtfnkpdcsshvoxxy")
    public suspend fun repositoryUrl(`value`: Output<String>) {
        this.repositoryUrl = value
    }

    /**
     * @param value The URL of the Git repository.
     */
    @JvmName("ripsbfuxjgtygyrn")
    public suspend fun repositoryUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryUrl = mapped
    }

    internal fun build(): UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs =
        UserProfileUserSettingsJupyterServerAppSettingsCodeRepositoryArgs(
            repositoryUrl = repositoryUrl ?: throw PulumiNullFieldException("repositoryUrl"),
        )
}
