@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsKernelGatewayAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class UserProfileUserSettingsKernelGatewayAppSettingsArgs(
    public val customImages: Output<List<UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec: Output<UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsKernelGatewayAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsKernelGatewayAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsKernelGatewayAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsKernelGatewayAppSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsKernelGatewayAppSettingsArgsBuilder internal constructor() {
    private var customImages:
        Output<List<UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("sdjsbsbetwlulbmi")
    public suspend fun customImages(`value`: Output<List<UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("qaaaiqdlrrvnanje")
    public suspend fun customImages(vararg values: Output<UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgs>) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("iqbgfsooxhmpikog")
    public suspend fun customImages(values: List<Output<UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("lbfbuqrsausuloya")
    public suspend fun defaultResourceSpec(`value`: Output<UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("aqolwvehnixrdqle")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("oqmxbrsbkanignrw")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("nhnqlrejptumjwet")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("vquhuxqcavvqcdwr")
    public suspend fun customImages(`value`: List<UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("bgaxqnfbkhgkqjox")
    public suspend fun customImages(argument: List<suspend UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("aahawsfvsxpwksxa")
    public suspend fun customImages(vararg argument: suspend UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("dncusyflidswhslt")
    public suspend fun customImages(argument: suspend UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("kgsuusxythhttucf")
    public suspend fun customImages(vararg values: UserProfileUserSettingsKernelGatewayAppSettingsCustomImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("kvxlvxjysfbsiljv")
    public suspend fun defaultResourceSpec(`value`: UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("thdxjxfqnhebabqp")
    public suspend fun defaultResourceSpec(argument: suspend UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("rmsysqhisdeaabiy")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("xoktxuuetmorclna")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): UserProfileUserSettingsKernelGatewayAppSettingsArgs =
        UserProfileUserSettingsKernelGatewayAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
