@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
 * @property lifecycleConfigArn The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
 * @property sagemakerImageArn The ARN of the SageMaker image that the image version belongs to.
 * @property sagemakerImageVersionAlias The SageMaker Image Version Alias.
 * @property sagemakerImageVersionArn The ARN of the image version created on the instance.
 */
public data class UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs(
    public val instanceType: Output<String>? = null,
    public val lifecycleConfigArn: Output<String>? = null,
    public val sagemakerImageArn: Output<String>? = null,
    public val sagemakerImageVersionAlias: Output<String>? = null,
    public val sagemakerImageVersionArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs.builder()
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .lifecycleConfigArn(lifecycleConfigArn?.applyValue({ args0 -> args0 }))
            .sagemakerImageArn(sagemakerImageArn?.applyValue({ args0 -> args0 }))
            .sagemakerImageVersionAlias(sagemakerImageVersionAlias?.applyValue({ args0 -> args0 }))
            .sagemakerImageVersionArn(sagemakerImageVersionArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var lifecycleConfigArn: Output<String>? = null

    private var sagemakerImageArn: Output<String>? = null

    private var sagemakerImageVersionAlias: Output<String>? = null

    private var sagemakerImageVersionArn: Output<String>? = null

    /**
     * @param value The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
     */
    @JvmName("tujyxmaopvmtqoyi")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    @JvmName("eqbnphavsxpssvti")
    public suspend fun lifecycleConfigArn(`value`: Output<String>) {
        this.lifecycleConfigArn = value
    }

    /**
     * @param value The ARN of the SageMaker image that the image version belongs to.
     */
    @JvmName("vyarhbkigfobwqgo")
    public suspend fun sagemakerImageArn(`value`: Output<String>) {
        this.sagemakerImageArn = value
    }

    /**
     * @param value The SageMaker Image Version Alias.
     */
    @JvmName("pulimvkyebqlogyr")
    public suspend fun sagemakerImageVersionAlias(`value`: Output<String>) {
        this.sagemakerImageVersionAlias = value
    }

    /**
     * @param value The ARN of the image version created on the instance.
     */
    @JvmName("pfdhpiastqgigirr")
    public suspend fun sagemakerImageVersionArn(`value`: Output<String>) {
        this.sagemakerImageVersionArn = value
    }

    /**
     * @param value The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
     */
    @JvmName("htonveefuynnvrbi")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    @JvmName("bfrjddmjcelqjwxi")
    public suspend fun lifecycleConfigArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArn = mapped
    }

    /**
     * @param value The ARN of the SageMaker image that the image version belongs to.
     */
    @JvmName("cuulsvsrfacrwutw")
    public suspend fun sagemakerImageArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageArn = mapped
    }

    /**
     * @param value The SageMaker Image Version Alias.
     */
    @JvmName("aflmkxgopvvdwgfw")
    public suspend fun sagemakerImageVersionAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageVersionAlias = mapped
    }

    /**
     * @param value The ARN of the image version created on the instance.
     */
    @JvmName("evgywwqapfngrhgd")
    public suspend fun sagemakerImageVersionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageVersionArn = mapped
    }

    internal fun build(): UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs =
        UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs(
            instanceType = instanceType,
            lifecycleConfigArn = lifecycleConfigArn,
            sagemakerImageArn = sagemakerImageArn,
            sagemakerImageVersionAlias = sagemakerImageVersionAlias,
            sagemakerImageVersionArn = sagemakerImageVersionArn,
        )
}
