@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRStudioServerProAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessStatus Indicates whether the current user has access to the RStudioServerPro app. Valid values are `ENABLED` and `DISABLED`.
 * @property userGroup The level of permissions that the user has within the RStudioServerPro app. This value defaults to `R_STUDIO_USER`. The `R_STUDIO_ADMIN` value allows the user access to the RStudio Administrative Dashboard. Valid values are `R_STUDIO_USER` and `R_STUDIO_ADMIN`.
 */
public data class UserProfileUserSettingsRStudioServerProAppSettingsArgs(
    public val accessStatus: Output<String>? = null,
    public val userGroup: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRStudioServerProAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRStudioServerProAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRStudioServerProAppSettingsArgs.builder()
            .accessStatus(accessStatus?.applyValue({ args0 -> args0 }))
            .userGroup(userGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileUserSettingsRStudioServerProAppSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsRStudioServerProAppSettingsArgsBuilder internal constructor() {
    private var accessStatus: Output<String>? = null

    private var userGroup: Output<String>? = null

    /**
     * @param value Indicates whether the current user has access to the RStudioServerPro app. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("okwddtogakixryrg")
    public suspend fun accessStatus(`value`: Output<String>) {
        this.accessStatus = value
    }

    /**
     * @param value The level of permissions that the user has within the RStudioServerPro app. This value defaults to `R_STUDIO_USER`. The `R_STUDIO_ADMIN` value allows the user access to the RStudio Administrative Dashboard. Valid values are `R_STUDIO_USER` and `R_STUDIO_ADMIN`.
     */
    @JvmName("sxygvcljqhthdknq")
    public suspend fun userGroup(`value`: Output<String>) {
        this.userGroup = value
    }

    /**
     * @param value Indicates whether the current user has access to the RStudioServerPro app. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("stfncgqxlgpwoovp")
    public suspend fun accessStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessStatus = mapped
    }

    /**
     * @param value The level of permissions that the user has within the RStudioServerPro app. This value defaults to `R_STUDIO_USER`. The `R_STUDIO_ADMIN` value allows the user access to the RStudio Administrative Dashboard. Valid values are `R_STUDIO_USER` and `R_STUDIO_ADMIN`.
     */
    @JvmName("iexsbtpwonwbowxg")
    public suspend fun userGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userGroup = mapped
    }

    internal fun build(): UserProfileUserSettingsRStudioServerProAppSettingsArgs =
        UserProfileUserSettingsRStudioServerProAppSettingsArgs(
            accessStatus = accessStatus,
            userGroup = userGroup,
        )
}
