@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsSpaceStorageSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property defaultEbsStorageSettings The default EBS storage settings for a private space. See Default EBS Storage Settings below.
 */
public data class UserProfileUserSettingsSpaceStorageSettingsArgs(
    public val defaultEbsStorageSettings: Output<UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsSpaceStorageSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsSpaceStorageSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsSpaceStorageSettingsArgs.builder()
            .defaultEbsStorageSettings(
                defaultEbsStorageSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsSpaceStorageSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsSpaceStorageSettingsArgsBuilder internal constructor() {
    private var defaultEbsStorageSettings:
        Output<UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs>? = null

    /**
     * @param value The default EBS storage settings for a private space. See Default EBS Storage Settings below.
     */
    @JvmName("nrnumbpnoyvbfcyq")
    public suspend fun defaultEbsStorageSettings(`value`: Output<UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs>) {
        this.defaultEbsStorageSettings = value
    }

    /**
     * @param value The default EBS storage settings for a private space. See Default EBS Storage Settings below.
     */
    @JvmName("tsnoksiaowdbyofx")
    public suspend fun defaultEbsStorageSettings(`value`: UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultEbsStorageSettings = mapped
    }

    /**
     * @param argument The default EBS storage settings for a private space. See Default EBS Storage Settings below.
     */
    @JvmName("hvgkckxmfpoikkny")
    public suspend fun defaultEbsStorageSettings(argument: suspend UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultEbsStorageSettings = mapped
    }

    internal fun build(): UserProfileUserSettingsSpaceStorageSettingsArgs =
        UserProfileUserSettingsSpaceStorageSettingsArgs(
            defaultEbsStorageSettings = defaultEbsStorageSettings,
        )
}
