@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultEbsVolumeSizeInGb The default size of the EBS storage volume for a private space.
 * @property maximumEbsVolumeSizeInGb The maximum size of the EBS storage volume for a private space.
 */
public data class UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs(
    public val defaultEbsVolumeSizeInGb: Output<Int>,
    public val maximumEbsVolumeSizeInGb: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs.builder()
            .defaultEbsVolumeSizeInGb(defaultEbsVolumeSizeInGb.applyValue({ args0 -> args0 }))
            .maximumEbsVolumeSizeInGb(maximumEbsVolumeSizeInGb.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgsBuilder
internal constructor() {
    private var defaultEbsVolumeSizeInGb: Output<Int>? = null

    private var maximumEbsVolumeSizeInGb: Output<Int>? = null

    /**
     * @param value The default size of the EBS storage volume for a private space.
     */
    @JvmName("xvhevdbnqhongxnf")
    public suspend fun defaultEbsVolumeSizeInGb(`value`: Output<Int>) {
        this.defaultEbsVolumeSizeInGb = value
    }

    /**
     * @param value The maximum size of the EBS storage volume for a private space.
     */
    @JvmName("qogirtcbrgsdrngw")
    public suspend fun maximumEbsVolumeSizeInGb(`value`: Output<Int>) {
        this.maximumEbsVolumeSizeInGb = value
    }

    /**
     * @param value The default size of the EBS storage volume for a private space.
     */
    @JvmName("nordcrhsdjlxahmb")
    public suspend fun defaultEbsVolumeSizeInGb(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultEbsVolumeSizeInGb = mapped
    }

    /**
     * @param value The maximum size of the EBS storage volume for a private space.
     */
    @JvmName("wvesriudghpyluqc")
    public suspend fun maximumEbsVolumeSizeInGb(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumEbsVolumeSizeInGb = mapped
    }

    internal fun build(): UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs =
        UserProfileUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs(
            defaultEbsVolumeSizeInGb = defaultEbsVolumeSizeInGb ?: throw
                PulumiNullFieldException("defaultEbsVolumeSizeInGb"),
            maximumEbsVolumeSizeInGb = maximumEbsVolumeSizeInGb ?: throw
                PulumiNullFieldException("maximumEbsVolumeSizeInGb"),
        )
}
