@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsTensorBoardAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 */
public data class UserProfileUserSettingsTensorBoardAppSettingsArgs(
    public val defaultResourceSpec: Output<UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsTensorBoardAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsTensorBoardAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsTensorBoardAppSettingsArgs.builder()
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsTensorBoardAppSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsTensorBoardAppSettingsArgsBuilder internal constructor() {
    private var defaultResourceSpec:
        Output<UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs>? = null

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("wwnsxsswrqvdasnh")
    public suspend fun defaultResourceSpec(`value`: Output<UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("btdcbpxvwkohawmw")
    public suspend fun defaultResourceSpec(`value`: UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("mftbwshfkyiknnsk")
    public suspend fun defaultResourceSpec(argument: suspend UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    internal fun build(): UserProfileUserSettingsTensorBoardAppSettingsArgs =
        UserProfileUserSettingsTensorBoardAppSettingsArgs(
            defaultResourceSpec = defaultResourceSpec,
        )
}
