@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkforceCognitoConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientId The client ID for your Amazon Cognito user pool.
 * @property userPool ID for your Amazon Cognito user pool.
 */
public data class WorkforceCognitoConfigArgs(
    public val clientId: Output<String>,
    public val userPool: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkforceCognitoConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.WorkforceCognitoConfigArgs =
        com.pulumi.aws.sagemaker.inputs.WorkforceCognitoConfigArgs.builder()
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .userPool(userPool.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkforceCognitoConfigArgs].
 */
@PulumiTagMarker
public class WorkforceCognitoConfigArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var userPool: Output<String>? = null

    /**
     * @param value The client ID for your Amazon Cognito user pool.
     */
    @JvmName("yikxquhfdcbixglo")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value ID for your Amazon Cognito user pool.
     */
    @JvmName("xyjeickwrmogawxi")
    public suspend fun userPool(`value`: Output<String>) {
        this.userPool = value
    }

    /**
     * @param value The client ID for your Amazon Cognito user pool.
     */
    @JvmName("mbswsnalujxtrpym")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value ID for your Amazon Cognito user pool.
     */
    @JvmName("hshqmilteeoistwy")
    public suspend fun userPool(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPool = mapped
    }

    internal fun build(): WorkforceCognitoConfigArgs = WorkforceCognitoConfigArgs(
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        userPool = userPool ?: throw PulumiNullFieldException("userPool"),
    )
}
