@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkforceOidcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationRequestExtraParams A string to string map of identifiers specific to the custom identity provider (IdP) being used.
 * @property authorizationEndpoint The OIDC IdP authorization endpoint used to configure your private workforce.
 * @property clientId The OIDC IdP client ID used to configure your private workforce.
 * @property clientSecret The OIDC IdP client secret used to configure your private workforce.
 * @property issuer The OIDC IdP issuer used to configure your private workforce.
 * @property jwksUri The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
 * @property logoutEndpoint The OIDC IdP logout endpoint used to configure your private workforce.
 * @property scope An array of string identifiers used to refer to the specific pieces of user data or claims that the client application wants to access.
 * @property tokenEndpoint The OIDC IdP token endpoint used to configure your private workforce.
 * @property userInfoEndpoint The OIDC IdP user information endpoint used to configure your private workforce.
 */
public data class WorkforceOidcConfigArgs(
    public val authenticationRequestExtraParams: Output<Map<String, String>>? = null,
    public val authorizationEndpoint: Output<String>,
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
    public val issuer: Output<String>,
    public val jwksUri: Output<String>,
    public val logoutEndpoint: Output<String>,
    public val scope: Output<String>? = null,
    public val tokenEndpoint: Output<String>,
    public val userInfoEndpoint: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkforceOidcConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.WorkforceOidcConfigArgs =
        com.pulumi.aws.sagemaker.inputs.WorkforceOidcConfigArgs.builder()
            .authenticationRequestExtraParams(
                authenticationRequestExtraParams?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .authorizationEndpoint(authorizationEndpoint.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 }))
            .issuer(issuer.applyValue({ args0 -> args0 }))
            .jwksUri(jwksUri.applyValue({ args0 -> args0 }))
            .logoutEndpoint(logoutEndpoint.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .tokenEndpoint(tokenEndpoint.applyValue({ args0 -> args0 }))
            .userInfoEndpoint(userInfoEndpoint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkforceOidcConfigArgs].
 */
@PulumiTagMarker
public class WorkforceOidcConfigArgsBuilder internal constructor() {
    private var authenticationRequestExtraParams: Output<Map<String, String>>? = null

    private var authorizationEndpoint: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var issuer: Output<String>? = null

    private var jwksUri: Output<String>? = null

    private var logoutEndpoint: Output<String>? = null

    private var scope: Output<String>? = null

    private var tokenEndpoint: Output<String>? = null

    private var userInfoEndpoint: Output<String>? = null

    /**
     * @param value A string to string map of identifiers specific to the custom identity provider (IdP) being used.
     */
    @JvmName("iidmwcmesshvomlp")
    public suspend fun authenticationRequestExtraParams(`value`: Output<Map<String, String>>) {
        this.authenticationRequestExtraParams = value
    }

    /**
     * @param value The OIDC IdP authorization endpoint used to configure your private workforce.
     */
    @JvmName("wwnviipkhyvkpgqt")
    public suspend fun authorizationEndpoint(`value`: Output<String>) {
        this.authorizationEndpoint = value
    }

    /**
     * @param value The OIDC IdP client ID used to configure your private workforce.
     */
    @JvmName("mtuisweugshhgmac")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The OIDC IdP client secret used to configure your private workforce.
     */
    @JvmName("ossmoqonxvoecice")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The OIDC IdP issuer used to configure your private workforce.
     */
    @JvmName("unbchdppqslbrxch")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
     */
    @JvmName("wxpxpkyoiokdwlid")
    public suspend fun jwksUri(`value`: Output<String>) {
        this.jwksUri = value
    }

    /**
     * @param value The OIDC IdP logout endpoint used to configure your private workforce.
     */
    @JvmName("ydpmyvohtyyuptlc")
    public suspend fun logoutEndpoint(`value`: Output<String>) {
        this.logoutEndpoint = value
    }

    /**
     * @param value An array of string identifiers used to refer to the specific pieces of user data or claims that the client application wants to access.
     */
    @JvmName("exdvetkhhrheskul")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The OIDC IdP token endpoint used to configure your private workforce.
     */
    @JvmName("qfxtkhhxufgbqbas")
    public suspend fun tokenEndpoint(`value`: Output<String>) {
        this.tokenEndpoint = value
    }

    /**
     * @param value The OIDC IdP user information endpoint used to configure your private workforce.
     */
    @JvmName("nkpsrpvkgdeyxiyo")
    public suspend fun userInfoEndpoint(`value`: Output<String>) {
        this.userInfoEndpoint = value
    }

    /**
     * @param value A string to string map of identifiers specific to the custom identity provider (IdP) being used.
     */
    @JvmName("sdpxxbshuiospffl")
    public suspend fun authenticationRequestExtraParams(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param values A string to string map of identifiers specific to the custom identity provider (IdP) being used.
     */
    @JvmName("jxywtlxxpgqvbtkv")
    public fun authenticationRequestExtraParams(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param value The OIDC IdP authorization endpoint used to configure your private workforce.
     */
    @JvmName("dalionsfypnwedbp")
    public suspend fun authorizationEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationEndpoint = mapped
    }

    /**
     * @param value The OIDC IdP client ID used to configure your private workforce.
     */
    @JvmName("axlrmaaxceolgaja")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The OIDC IdP client secret used to configure your private workforce.
     */
    @JvmName("votbidxknyqhtsfq")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The OIDC IdP issuer used to configure your private workforce.
     */
    @JvmName("rqcpcacpkmvbghop")
    public suspend fun issuer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
     */
    @JvmName("pqeqsdshgvrfiorh")
    public suspend fun jwksUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jwksUri = mapped
    }

    /**
     * @param value The OIDC IdP logout endpoint used to configure your private workforce.
     */
    @JvmName("fyahhbsadbguwkbl")
    public suspend fun logoutEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logoutEndpoint = mapped
    }

    /**
     * @param value An array of string identifiers used to refer to the specific pieces of user data or claims that the client application wants to access.
     */
    @JvmName("eljvtpkhfasmixao")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The OIDC IdP token endpoint used to configure your private workforce.
     */
    @JvmName("wngjbriwhicuxbmq")
    public suspend fun tokenEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenEndpoint = mapped
    }

    /**
     * @param value The OIDC IdP user information endpoint used to configure your private workforce.
     */
    @JvmName("pggouiusnsfxtmfc")
    public suspend fun userInfoEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userInfoEndpoint = mapped
    }

    internal fun build(): WorkforceOidcConfigArgs = WorkforceOidcConfigArgs(
        authenticationRequestExtraParams = authenticationRequestExtraParams,
        authorizationEndpoint = authorizationEndpoint ?: throw
            PulumiNullFieldException("authorizationEndpoint"),
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
        issuer = issuer ?: throw PulumiNullFieldException("issuer"),
        jwksUri = jwksUri ?: throw PulumiNullFieldException("jwksUri"),
        logoutEndpoint = logoutEndpoint ?: throw PulumiNullFieldException("logoutEndpoint"),
        scope = scope,
        tokenEndpoint = tokenEndpoint ?: throw PulumiNullFieldException("tokenEndpoint"),
        userInfoEndpoint = userInfoEndpoint ?: throw PulumiNullFieldException("userInfoEndpoint"),
    )
}
