@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkforceSourceIpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cidrs A list of up to 10 CIDR values.
 */
public data class WorkforceSourceIpConfigArgs(
    public val cidrs: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkforceSourceIpConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.WorkforceSourceIpConfigArgs =
        com.pulumi.aws.sagemaker.inputs.WorkforceSourceIpConfigArgs.builder()
            .cidrs(cidrs.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WorkforceSourceIpConfigArgs].
 */
@PulumiTagMarker
public class WorkforceSourceIpConfigArgsBuilder internal constructor() {
    private var cidrs: Output<List<String>>? = null

    /**
     * @param value A list of up to 10 CIDR values.
     */
    @JvmName("vjrihqqdslacfnpy")
    public suspend fun cidrs(`value`: Output<List<String>>) {
        this.cidrs = value
    }

    @JvmName("xtkqxjndbmcpnhec")
    public suspend fun cidrs(vararg values: Output<String>) {
        this.cidrs = Output.all(values.asList())
    }

    /**
     * @param values A list of up to 10 CIDR values.
     */
    @JvmName("dfpiheqhvpjtcpkv")
    public suspend fun cidrs(values: List<Output<String>>) {
        this.cidrs = Output.all(values)
    }

    /**
     * @param value A list of up to 10 CIDR values.
     */
    @JvmName("kgeihwhbenoitrey")
    public suspend fun cidrs(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param values A list of up to 10 CIDR values.
     */
    @JvmName("drpdmkncirocjcfw")
    public suspend fun cidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    internal fun build(): WorkforceSourceIpConfigArgs = WorkforceSourceIpConfigArgs(
        cidrs = cidrs ?: throw PulumiNullFieldException("cidrs"),
    )
}
