@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cognitoMemberDefinition The Amazon Cognito user group that is part of the work team. See Cognito Member Definition details below.
 * @property oidcMemberDefinition A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. See Cognito Member Definition details below.
 */
public data class WorkteamMemberDefinitionArgs(
    public val cognitoMemberDefinition: Output<WorkteamMemberDefinitionCognitoMemberDefinitionArgs>? =
        null,
    public val oidcMemberDefinition: Output<WorkteamMemberDefinitionOidcMemberDefinitionArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs =
        com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs.builder()
            .cognitoMemberDefinition(
                cognitoMemberDefinition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .oidcMemberDefinition(
                oidcMemberDefinition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkteamMemberDefinitionArgs].
 */
@PulumiTagMarker
public class WorkteamMemberDefinitionArgsBuilder internal constructor() {
    private var cognitoMemberDefinition: Output<WorkteamMemberDefinitionCognitoMemberDefinitionArgs>? =
        null

    private var oidcMemberDefinition: Output<WorkteamMemberDefinitionOidcMemberDefinitionArgs>? = null

    /**
     * @param value The Amazon Cognito user group that is part of the work team. See Cognito Member Definition details below.
     */
    @JvmName("lnevxfyavvjatnlx")
    public suspend fun cognitoMemberDefinition(`value`: Output<WorkteamMemberDefinitionCognitoMemberDefinitionArgs>) {
        this.cognitoMemberDefinition = value
    }

    /**
     * @param value A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. See Cognito Member Definition details below.
     */
    @JvmName("gxeoufrcpbyyoalk")
    public suspend fun oidcMemberDefinition(`value`: Output<WorkteamMemberDefinitionOidcMemberDefinitionArgs>) {
        this.oidcMemberDefinition = value
    }

    /**
     * @param value The Amazon Cognito user group that is part of the work team. See Cognito Member Definition details below.
     */
    @JvmName("nopgpukjuqoddatq")
    public suspend fun cognitoMemberDefinition(`value`: WorkteamMemberDefinitionCognitoMemberDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitoMemberDefinition = mapped
    }

    /**
     * @param argument The Amazon Cognito user group that is part of the work team. See Cognito Member Definition details below.
     */
    @JvmName("unepculnrfpnxnhm")
    public suspend fun cognitoMemberDefinition(argument: suspend WorkteamMemberDefinitionCognitoMemberDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = WorkteamMemberDefinitionCognitoMemberDefinitionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cognitoMemberDefinition = mapped
    }

    /**
     * @param value A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. See Cognito Member Definition details below.
     */
    @JvmName("cxojwxjgjlbamuww")
    public suspend fun oidcMemberDefinition(`value`: WorkteamMemberDefinitionOidcMemberDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcMemberDefinition = mapped
    }

    /**
     * @param argument A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. See Cognito Member Definition details below.
     */
    @JvmName("nndiiojyfjocxpqn")
    public suspend fun oidcMemberDefinition(argument: suspend WorkteamMemberDefinitionOidcMemberDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = WorkteamMemberDefinitionOidcMemberDefinitionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.oidcMemberDefinition = mapped
    }

    internal fun build(): WorkteamMemberDefinitionArgs = WorkteamMemberDefinitionArgs(
        cognitoMemberDefinition = cognitoMemberDefinition,
        oidcMemberDefinition = oidcMemberDefinition,
    )
}
