@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkteamWorkerAccessConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Presign Defines any Amazon S3 resource constraints. see S3 Presign details below.
 */
public data class WorkteamWorkerAccessConfigurationArgs(
    public val s3Presign: Output<WorkteamWorkerAccessConfigurationS3PresignArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkteamWorkerAccessConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.WorkteamWorkerAccessConfigurationArgs =
        com.pulumi.aws.sagemaker.inputs.WorkteamWorkerAccessConfigurationArgs.builder()
            .s3Presign(s3Presign?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WorkteamWorkerAccessConfigurationArgs].
 */
@PulumiTagMarker
public class WorkteamWorkerAccessConfigurationArgsBuilder internal constructor() {
    private var s3Presign: Output<WorkteamWorkerAccessConfigurationS3PresignArgs>? = null

    /**
     * @param value Defines any Amazon S3 resource constraints. see S3 Presign details below.
     */
    @JvmName("hlbyuowxutsuedme")
    public suspend fun s3Presign(`value`: Output<WorkteamWorkerAccessConfigurationS3PresignArgs>) {
        this.s3Presign = value
    }

    /**
     * @param value Defines any Amazon S3 resource constraints. see S3 Presign details below.
     */
    @JvmName("uakcudyqmnblcwle")
    public suspend fun s3Presign(`value`: WorkteamWorkerAccessConfigurationS3PresignArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Presign = mapped
    }

    /**
     * @param argument Defines any Amazon S3 resource constraints. see S3 Presign details below.
     */
    @JvmName("ochpprurxhbckfme")
    public suspend fun s3Presign(argument: suspend WorkteamWorkerAccessConfigurationS3PresignArgsBuilder.() -> Unit) {
        val toBeMapped = WorkteamWorkerAccessConfigurationS3PresignArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Presign = mapped
    }

    internal fun build(): WorkteamWorkerAccessConfigurationArgs =
        WorkteamWorkerAccessConfigurationArgs(
            s3Presign = s3Presign,
        )
}
