@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkteamWorkerAccessConfigurationS3PresignArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property iamPolicyConstraints Use this parameter to specify the allowed request source. Possible sources are either SourceIp or VpcSourceIp. see IAM Policy Constraints details below.
 */
public data class WorkteamWorkerAccessConfigurationS3PresignArgs(
    public val iamPolicyConstraints: Output<WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraintsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkteamWorkerAccessConfigurationS3PresignArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.WorkteamWorkerAccessConfigurationS3PresignArgs =
        com.pulumi.aws.sagemaker.inputs.WorkteamWorkerAccessConfigurationS3PresignArgs.builder()
            .iamPolicyConstraints(
                iamPolicyConstraints?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkteamWorkerAccessConfigurationS3PresignArgs].
 */
@PulumiTagMarker
public class WorkteamWorkerAccessConfigurationS3PresignArgsBuilder internal constructor() {
    private var iamPolicyConstraints:
        Output<WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraintsArgs>? = null

    /**
     * @param value Use this parameter to specify the allowed request source. Possible sources are either SourceIp or VpcSourceIp. see IAM Policy Constraints details below.
     */
    @JvmName("ciwksseiqfkdjpye")
    public suspend fun iamPolicyConstraints(`value`: Output<WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraintsArgs>) {
        this.iamPolicyConstraints = value
    }

    /**
     * @param value Use this parameter to specify the allowed request source. Possible sources are either SourceIp or VpcSourceIp. see IAM Policy Constraints details below.
     */
    @JvmName("ugthptoseppdlnsi")
    public suspend fun iamPolicyConstraints(`value`: WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraintsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamPolicyConstraints = mapped
    }

    /**
     * @param argument Use this parameter to specify the allowed request source. Possible sources are either SourceIp or VpcSourceIp. see IAM Policy Constraints details below.
     */
    @JvmName("cjeipdchunyiifrb")
    public suspend fun iamPolicyConstraints(argument: suspend WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraintsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkteamWorkerAccessConfigurationS3PresignIamPolicyConstraintsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.iamPolicyConstraints = mapped
    }

    internal fun build(): WorkteamWorkerAccessConfigurationS3PresignArgs =
        WorkteamWorkerAccessConfigurationS3PresignArgs(
            iamPolicyConstraints = iamPolicyConstraints,
        )
}
