@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property containerConfig The configuration used to run the application image container. See Container Config details below.
 * @property fileSystemConfig The URL where the Git repository is located. See File System Config details below.
 */
public data class AppImageConfigCodeEditorAppImageConfig(
    public val containerConfig: AppImageConfigCodeEditorAppImageConfigContainerConfig? = null,
    public val fileSystemConfig: AppImageConfigCodeEditorAppImageConfigFileSystemConfig? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.AppImageConfigCodeEditorAppImageConfig): AppImageConfigCodeEditorAppImageConfig = AppImageConfigCodeEditorAppImageConfig(
            containerConfig = javaType.containerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigCodeEditorAppImageConfigContainerConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fileSystemConfig = javaType.fileSystemConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigCodeEditorAppImageConfigFileSystemConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
