@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property containerConfig The configuration used to run the application image container. See Container Config details below.
 * @property fileSystemConfig The URL where the Git repository is located. See File System Config details below.
 */
public data class AppImageConfigJupyterLabImageConfig(
    public val containerConfig: AppImageConfigJupyterLabImageConfigContainerConfig? = null,
    public val fileSystemConfig: AppImageConfigJupyterLabImageConfigFileSystemConfig? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.AppImageConfigJupyterLabImageConfig): AppImageConfigJupyterLabImageConfig = AppImageConfigJupyterLabImageConfig(
            containerConfig = javaType.containerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigJupyterLabImageConfigContainerConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fileSystemConfig = javaType.fileSystemConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigJupyterLabImageConfigFileSystemConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
