@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property containerArguments The arguments for the container when you're running the application.
 * @property containerEntrypoints The entrypoint used to run the application in the container.
 * @property containerEnvironmentVariables The environment variables to set in the container.
 */
public data class AppImageConfigJupyterLabImageConfigContainerConfig(
    public val containerArguments: List<String>? = null,
    public val containerEntrypoints: List<String>? = null,
    public val containerEnvironmentVariables: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.AppImageConfigJupyterLabImageConfigContainerConfig): AppImageConfigJupyterLabImageConfigContainerConfig =
            AppImageConfigJupyterLabImageConfigContainerConfig(
                containerArguments = javaType.containerArguments().map({ args0 -> args0 }),
                containerEntrypoints = javaType.containerEntrypoints().map({ args0 -> args0 }),
                containerEnvironmentVariables = javaType.containerEnvironmentVariables().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
            )
    }
}
