@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property branch The default branch for the Git repository.
 * @property repositoryUrl The URL where the Git repository is located.
 * @property secretArn The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of AWSCURRENT and must be in the following format: `{"username": UserName, "password": Password}`
 */
public data class CodeRepositoryGitConfig(
    public val branch: String? = null,
    public val repositoryUrl: String,
    public val secretArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.CodeRepositoryGitConfig): CodeRepositoryGitConfig = CodeRepositoryGitConfig(
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            repositoryUrl = javaType.repositoryUrl(),
            secretArn = javaType.secretArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
