@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property environment Sets the environment variables in the container that the monitoring job runs. A list of key value pairs.
 * @property imageUri The container image that the data quality monitoring job runs.
 * @property postAnalyticsProcessorSourceUri An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
 * @property recordPreprocessorSourceUri An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
 */
public data class DataQualityJobDefinitionDataQualityAppSpecification(
    public val environment: Map<String, String>? = null,
    public val imageUri: String,
    public val postAnalyticsProcessorSourceUri: String? = null,
    public val recordPreprocessorSourceUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DataQualityJobDefinitionDataQualityAppSpecification): DataQualityJobDefinitionDataQualityAppSpecification =
            DataQualityJobDefinitionDataQualityAppSpecification(
                environment = javaType.environment().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                imageUri = javaType.imageUri(),
                postAnalyticsProcessorSourceUri = javaType.postAnalyticsProcessorSourceUri().map({ args0 ->
                    args0
                }).orElse(null),
                recordPreprocessorSourceUri = javaType.recordPreprocessorSourceUri().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
