@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
 * @property monitoringOutputs Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded. Fields are documented below.
 */
public data class DataQualityJobDefinitionDataQualityJobOutputConfig(
    public val kmsKeyId: String? = null,
    public val monitoringOutputs: DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputs,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DataQualityJobDefinitionDataQualityJobOutputConfig): DataQualityJobDefinitionDataQualityJobOutputConfig =
            DataQualityJobDefinitionDataQualityJobOutputConfig(
                kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
                monitoringOutputs = javaType.monitoringOutputs().let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputs.Companion.toKotlin(args0)
                }),
            )
    }
}
