@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property localPath The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data. Defaults to `/opt/ml/processing/output`.
 * @property s3UploadMode Whether to upload the results of the monitoring job continuously or after the job completes. Valid values are `Continuous` or `EndOfJob`
 * @property s3Uri A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
 */
public data class DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3Output(
    public val localPath: String? = null,
    public val s3UploadMode: String? = null,
    public val s3Uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3Output): DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3Output =
            DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3Output(
                localPath = javaType.localPath().map({ args0 -> args0 }).orElse(null),
                s3UploadMode = javaType.s3UploadMode().map({ args0 -> args0 }).orElse(null),
                s3Uri = javaType.s3Uri(),
            )
    }
}
