@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceCount The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1.
 * @property instanceType The ML compute instance type for the processing job.
 * @property volumeKmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
 * @property volumeSizeInGb The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
 */
public data class DataQualityJobDefinitionJobResourcesClusterConfig(
    public val instanceCount: Int,
    public val instanceType: String,
    public val volumeKmsKeyId: String? = null,
    public val volumeSizeInGb: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DataQualityJobDefinitionJobResourcesClusterConfig): DataQualityJobDefinitionJobResourcesClusterConfig =
            DataQualityJobDefinitionJobResourcesClusterConfig(
                instanceCount = javaType.instanceCount(),
                instanceType = javaType.instanceType(),
                volumeKmsKeyId = javaType.volumeKmsKeyId().map({ args0 -> args0 }).orElse(null),
                volumeSizeInGb = javaType.volumeSizeInGb(),
            )
    }
}
