@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description A description for the device.
 * @property deviceName The name of the device.
 * @property iotThingName Amazon Web Services Internet of Things (IoT) object name.
 */
public data class DeviceDevice(
    public val description: String? = null,
    public val deviceName: String,
    public val iotThingName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DeviceDevice): DeviceDevice =
            DeviceDevice(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                deviceName = javaType.deviceName(),
                iotThingName = javaType.iotThingName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
