@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property executionRole The execution role for the space.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
 * @property securityGroups The security groups for the Amazon Virtual Private Cloud that the space uses for communication.
 */
public data class DomainDefaultSpaceSettings(
    public val executionRole: String,
    public val jupyterServerAppSettings: DomainDefaultSpaceSettingsJupyterServerAppSettings? = null,
    public val kernelGatewayAppSettings: DomainDefaultSpaceSettingsKernelGatewayAppSettings? = null,
    public val securityGroups: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultSpaceSettings): DomainDefaultSpaceSettings = DomainDefaultSpaceSettings(
            executionRole = javaType.executionRole(),
            jupyterServerAppSettings = javaType.jupyterServerAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultSpaceSettingsJupyterServerAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kernelGatewayAppSettings = javaType.kernelGatewayAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultSpaceSettingsKernelGatewayAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
        )
    }
}
