@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultSpaceSettingsJupyterServerAppSettings(
    public val codeRepositories: List<DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepository>? = null,
    public val defaultResourceSpec: DomainDefaultSpaceSettingsJupyterServerAppSettingsDefaultResourceSpec? = null,
    public val lifecycleConfigArns: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultSpaceSettingsJupyterServerAppSettings): DomainDefaultSpaceSettingsJupyterServerAppSettings =
            DomainDefaultSpaceSettingsJupyterServerAppSettings(
                codeRepositories = javaType.codeRepositories().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepository.Companion.toKotlin(args0)
                    })
                }),
                defaultResourceSpec = javaType.defaultResourceSpec().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultSpaceSettingsJupyterServerAppSettingsDefaultResourceSpec.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lifecycleConfigArns = javaType.lifecycleConfigArns().map({ args0 -> args0 }),
            )
    }
}
