@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property canvasAppSettings The Canvas app settings. See `canvas_app_settings` Block below.
 * @property codeEditorAppSettings The Code Editor application settings. See `code_editor_app_settings` Block below.
 * @property customFileSystemConfigs The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See `custom_file_system_config` Block below.
 * @property customPosixUserConfig Details about the POSIX identity that is used for file system operations. See `custom_posix_user_config` Block below.
 * @property defaultLandingUri The default experience that the user is directed to when accessing the domain. The supported values are: `studio::`: Indicates that Studio is the default experience. This value can only be passed if StudioWebPortal is set to ENABLED. `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
 * @property executionRole The execution role ARN for the user.
 * @property jupyterLabAppSettings The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
 * @property rSessionAppSettings The RSession app settings. See `r_session_app_settings` Block below.
 * @property rStudioServerProAppSettings A collection of settings that configure user interaction with the RStudioServerPro app. See `r_studio_server_pro_app_settings` Block below.
 * @property securityGroups A list of security group IDs that will be attached to the user.
 * @property sharingSettings The sharing settings. See `sharing_settings` Block below.
 * @property spaceStorageSettings The storage settings for a private space. See `space_storage_settings` Block below.
 * @property studioWebPortal Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain. Valid values are `ENABLED` and `DISABLED`.
 * @property tensorBoardAppSettings The TensorBoard app settings. See `tensor_board_app_settings` Block below.
 */
public data class DomainDefaultUserSettings(
    public val canvasAppSettings: DomainDefaultUserSettingsCanvasAppSettings? = null,
    public val codeEditorAppSettings: DomainDefaultUserSettingsCodeEditorAppSettings? = null,
    public val customFileSystemConfigs: List<DomainDefaultUserSettingsCustomFileSystemConfig>? = null,
    public val customPosixUserConfig: DomainDefaultUserSettingsCustomPosixUserConfig? = null,
    public val defaultLandingUri: String? = null,
    public val executionRole: String,
    public val jupyterLabAppSettings: DomainDefaultUserSettingsJupyterLabAppSettings? = null,
    public val jupyterServerAppSettings: DomainDefaultUserSettingsJupyterServerAppSettings? = null,
    public val kernelGatewayAppSettings: DomainDefaultUserSettingsKernelGatewayAppSettings? = null,
    public val rSessionAppSettings: DomainDefaultUserSettingsRSessionAppSettings? = null,
    public val rStudioServerProAppSettings: DomainDefaultUserSettingsRStudioServerProAppSettings? =
        null,
    public val securityGroups: List<String>? = null,
    public val sharingSettings: DomainDefaultUserSettingsSharingSettings? = null,
    public val spaceStorageSettings: DomainDefaultUserSettingsSpaceStorageSettings? = null,
    public val studioWebPortal: String? = null,
    public val tensorBoardAppSettings: DomainDefaultUserSettingsTensorBoardAppSettings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettings): DomainDefaultUserSettings = DomainDefaultUserSettings(
            canvasAppSettings = javaType.canvasAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCanvasAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            codeEditorAppSettings = javaType.codeEditorAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCodeEditorAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customFileSystemConfigs = javaType.customFileSystemConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCustomFileSystemConfig.Companion.toKotlin(args0)
                })
            }),
            customPosixUserConfig = javaType.customPosixUserConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCustomPosixUserConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultLandingUri = javaType.defaultLandingUri().map({ args0 -> args0 }).orElse(null),
            executionRole = javaType.executionRole(),
            jupyterLabAppSettings = javaType.jupyterLabAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsJupyterLabAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jupyterServerAppSettings = javaType.jupyterServerAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsJupyterServerAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kernelGatewayAppSettings = javaType.kernelGatewayAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsKernelGatewayAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rSessionAppSettings = javaType.rSessionAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsRSessionAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rStudioServerProAppSettings = javaType.rStudioServerProAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsRStudioServerProAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            sharingSettings = javaType.sharingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsSharingSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            spaceStorageSettings = javaType.spaceStorageSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsSpaceStorageSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            studioWebPortal = javaType.studioWebPortal().map({ args0 -> args0 }).orElse(null),
            tensorBoardAppSettings = javaType.tensorBoardAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsTensorBoardAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
