@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property directDeploySettings The model deployment settings for the SageMaker Canvas application. See `direct_deploy_settings` Block below.
 * @property generativeAiSettings
 * @property identityProviderOauthSettings The settings for connecting to an external data source with OAuth. See `identity_provider_oauth_settings` Block below.
 * @property kendraSettings The settings for document querying. See `kendra_settings` Block below.
 * @property modelRegisterSettings The model registry settings for the SageMaker Canvas application. See `model_register_settings` Block below.
 * @property timeSeriesForecastingSettings Time series forecast settings for the Canvas app. See `time_series_forecasting_settings` Block below.
 * @property workspaceSettings The workspace settings for the SageMaker Canvas application. See `workspace_settings` Block below.
 */
public data class DomainDefaultUserSettingsCanvasAppSettings(
    public val directDeploySettings: DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettings? =
        null,
    public val generativeAiSettings: DomainDefaultUserSettingsCanvasAppSettingsGenerativeAiSettings? =
        null,
    public val identityProviderOauthSettings: List<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSetting>? = null,
    public val kendraSettings: DomainDefaultUserSettingsCanvasAppSettingsKendraSettings? = null,
    public val modelRegisterSettings: DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettings? =
        null,
    public val timeSeriesForecastingSettings: DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettings? = null,
    public val workspaceSettings: DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsCanvasAppSettings): DomainDefaultUserSettingsCanvasAppSettings = DomainDefaultUserSettingsCanvasAppSettings(
            directDeploySettings = javaType.directDeploySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            generativeAiSettings = javaType.generativeAiSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCanvasAppSettingsGenerativeAiSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            identityProviderOauthSettings = javaType.identityProviderOauthSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSetting.Companion.toKotlin(args0)
                })
            }),
            kendraSettings = javaType.kendraSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCanvasAppSettingsKendraSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            modelRegisterSettings = javaType.modelRegisterSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeSeriesForecastingSettings = javaType.timeSeriesForecastingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workspaceSettings = javaType.workspaceSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
