@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property crossAccountModelRegisterRoleArn The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model versions created by a different SageMaker Canvas AWS account than the AWS account in which SageMaker model registry is set up.
 * @property status Describes whether the integration to the model registry is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
 */
public data class DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettings(
    public val crossAccountModelRegisterRoleArn: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettings): DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettings =
            DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettings(
                crossAccountModelRegisterRoleArn = javaType.crossAccountModelRegisterRoleArn().map({ args0 ->
                    args0
                }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
