@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property amazonForecastRoleArn The IAM role that Canvas passes to Amazon Forecast for time series forecasting. By default, Canvas uses the execution role specified in the UserProfile that launches the Canvas app. If an execution role is not specified in the UserProfile, Canvas uses the execution role specified in the Domain that owns the UserProfile. To allow time series forecasting, this IAM role should have the [AmazonSageMakerCanvasForecastAccess](https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-canvas.html#security-iam-awsmanpol-AmazonSageMakerCanvasForecastAccess) policy attached and forecast.amazonaws.com added in the trust relationship as a service principal.
 * @property status Describes whether time series forecasting is enabled or disabled in the Canvas app. Valid values are `ENABLED` and `DISABLED`.
 */
public data class DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettings(
    public val amazonForecastRoleArn: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettings): DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettings =
            DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettings(
                amazonForecastRoleArn = javaType.amazonForecastRoleArn().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
