@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3ArtifactPath The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log out and log back in to apply the new location.
 * @property s3KmsKeyId The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.
 */
public data class DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettings(
    public val s3ArtifactPath: String? = null,
    public val s3KmsKeyId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettings): DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettings =
            DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettings(
                s3ArtifactPath = javaType.s3ArtifactPath().map({ args0 -> args0 }).orElse(null),
                s3KmsKeyId = javaType.s3KmsKeyId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
