@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appImageConfigName The name of the App Image Config.
 * @property imageName The name of the Custom Image.
 * @property imageVersionNumber The version number of the Custom Image.
 */
public data class DomainDefaultUserSettingsCodeEditorAppSettingsCustomImage(
    public val appImageConfigName: String,
    public val imageName: String,
    public val imageVersionNumber: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsCodeEditorAppSettingsCustomImage): DomainDefaultUserSettingsCodeEditorAppSettingsCustomImage =
            DomainDefaultUserSettingsCodeEditorAppSettingsCustomImage(
                appImageConfigName = javaType.appImageConfigName(),
                imageName = javaType.imageName(),
                imageVersionNumber = javaType.imageVersionNumber().map({ args0 -> args0 }).orElse(null),
            )
    }
}
