@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fileSystemId The ID of your Amazon EFS file system.
 * @property fileSystemPath The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.
 */
public data class DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfig(
    public val fileSystemId: String,
    public val fileSystemPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfig): DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfig =
            DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfig(
                fileSystemId = javaType.fileSystemId(),
                fileSystemPath = javaType.fileSystemPath(),
            )
    }
}
