@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
 * @property customImages A list of custom SageMaker images that are configured to run as a JupyterLab app. see `custom_image` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultUserSettingsJupyterLabAppSettings(
    public val codeRepositories: List<DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepository>? =
        null,
    public val customImages: List<DomainDefaultUserSettingsJupyterLabAppSettingsCustomImage>? = null,
    public val defaultResourceSpec: DomainDefaultUserSettingsJupyterLabAppSettingsDefaultResourceSpec? =
        null,
    public val lifecycleConfigArns: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsJupyterLabAppSettings): DomainDefaultUserSettingsJupyterLabAppSettings =
            DomainDefaultUserSettingsJupyterLabAppSettings(
                codeRepositories = javaType.codeRepositories().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepository.Companion.toKotlin(args0)
                    })
                }),
                customImages = javaType.customImages().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsJupyterLabAppSettingsCustomImage.Companion.toKotlin(args0)
                    })
                }),
                defaultResourceSpec = javaType.defaultResourceSpec().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsJupyterLabAppSettingsDefaultResourceSpec.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lifecycleConfigArns = javaType.lifecycleConfigArns().map({ args0 -> args0 }),
            )
    }
}
