@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a RSession app. see `custom_image` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block above.
 */
public data class DomainDefaultUserSettingsRSessionAppSettings(
    public val customImages: List<DomainDefaultUserSettingsRSessionAppSettingsCustomImage>? = null,
    public val defaultResourceSpec: DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpec? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsRSessionAppSettings): DomainDefaultUserSettingsRSessionAppSettings = DomainDefaultUserSettingsRSessionAppSettings(
            customImages = javaType.customImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsRSessionAppSettingsCustomImage.Companion.toKotlin(args0)
                })
            }),
            defaultResourceSpec = javaType.defaultResourceSpec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpec.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
