@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property executionRoleIdentityConfig The configuration for attaching a SageMaker user profile name to the execution role as a sts:SourceIdentity key [AWS Docs](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html). Valid values are `USER_PROFILE_NAME` and `DISABLED`.
 * @property rStudioServerProDomainSettings A collection of settings that configure the RStudioServerPro Domain-level app. see `r_studio_server_pro_domain_settings` Block below.
 * @property securityGroupIds The security groups for the Amazon Virtual Private Cloud that the Domain uses for communication between Domain-level apps and user apps.
 */
public data class DomainDomainSettings(
    public val executionRoleIdentityConfig: String? = null,
    public val rStudioServerProDomainSettings: DomainDomainSettingsRStudioServerProDomainSettings? =
        null,
    public val securityGroupIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDomainSettings): DomainDomainSettings = DomainDomainSettings(
            executionRoleIdentityConfig = javaType.executionRoleIdentityConfig().map({ args0 ->
                args0
            }).orElse(null),
            rStudioServerProDomainSettings = javaType.rStudioServerProDomainSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDomainSettingsRStudioServerProDomainSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
        )
    }
}
