@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block above.
 * @property domainExecutionRoleArn The ARN of the execution role for the RStudioServerPro Domain-level app.
 * @property rStudioConnectUrl A URL pointing to an RStudio Connect server.
 * @property rStudioPackageManagerUrl A URL pointing to an RStudio Package Manager server.
 */
public data class DomainDomainSettingsRStudioServerProDomainSettings(
    public val defaultResourceSpec: DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpec? = null,
    public val domainExecutionRoleArn: String,
    public val rStudioConnectUrl: String? = null,
    public val rStudioPackageManagerUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDomainSettingsRStudioServerProDomainSettings): DomainDomainSettingsRStudioServerProDomainSettings =
            DomainDomainSettingsRStudioServerProDomainSettings(
                defaultResourceSpec = javaType.defaultResourceSpec().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpec.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                domainExecutionRoleArn = javaType.domainExecutionRoleArn(),
                rStudioConnectUrl = javaType.rStudioConnectUrl().map({ args0 -> args0 }).orElse(null),
                rStudioPackageManagerUrl = javaType.rStudioPackageManagerUrl().map({ args0 -> args0 }).orElse(null),
            )
    }
}
