@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
 * @property lifecycleConfigArn The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
 * @property sagemakerImageArn The ARN of the SageMaker image that the image version belongs to.
 * @property sagemakerImageVersionAlias The SageMaker Image Version Alias.
 * @property sagemakerImageVersionArn The ARN of the image version created on the instance.
 */
public data class DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpec(
    public val instanceType: String? = null,
    public val lifecycleConfigArn: String? = null,
    public val sagemakerImageArn: String? = null,
    public val sagemakerImageVersionAlias: String? = null,
    public val sagemakerImageVersionArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpec): DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpec =
            DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpec(
                instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
                lifecycleConfigArn = javaType.lifecycleConfigArn().map({ args0 -> args0 }).orElse(null),
                sagemakerImageArn = javaType.sagemakerImageArn().map({ args0 -> args0 }).orElse(null),
                sagemakerImageVersionAlias = javaType.sagemakerImageVersionAlias().map({ args0 ->
                    args0
                }).orElse(null),
                sagemakerImageVersionArn = javaType.sagemakerImageVersionArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
