@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
 * @property notificationConfig Specifies the configuration for notifications of inference results for asynchronous inference.
 * @property s3FailurePath The Amazon S3 location to upload failure inference responses to.
 * @property s3OutputPath The Amazon S3 location to upload inference responses to.
 */
public data class EndpointConfigurationAsyncInferenceConfigOutputConfig(
    public val kmsKeyId: String? = null,
    public val notificationConfig: EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfig? = null,
    public val s3FailurePath: String? = null,
    public val s3OutputPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationAsyncInferenceConfigOutputConfig): EndpointConfigurationAsyncInferenceConfigOutputConfig =
            EndpointConfigurationAsyncInferenceConfigOutputConfig(
                kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
                notificationConfig = javaType.notificationConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                s3FailurePath = javaType.s3FailurePath().map({ args0 -> args0 }).orElse(null),
                s3OutputPath = javaType.s3OutputPath(),
            )
    }
}
