@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property csvContentTypes The CSV content type headers to capture.
 * @property jsonContentTypes The JSON content type headers to capture.
 */
public data class EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader(
    public val csvContentTypes: List<String>? = null,
    public val jsonContentTypes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader): EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader =
            EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader(
                csvContentTypes = javaType.csvContentTypes().map({ args0 -> args0 }),
                jsonContentTypes = javaType.jsonContentTypes().map({ args0 -> args0 }),
            )
    }
}
