@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property acceleratorType The size of the Elastic Inference (EI) instance to use for the production variant.
 * @property containerStartupHealthCheckTimeoutInSeconds The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests). Valid values between `60` and `3600`.
 * @property coreDumpConfig Specifies configuration for a core dump from the model container when the process crashes. Fields are documented below.
 * @property enableSsmAccess You can use this parameter to turn on native Amazon Web Services Systems Manager (SSM) access for a production variant behind an endpoint. By default, SSM access is disabled for all production variants behind an endpoints.
 * @property inferenceAmiVersion Specifies an option from a collection of preconfigured Amazon Machine Image (AMI) images. Each image is configured by Amazon Web Services with a set of software and driver versions. Amazon Web Services optimizes these configurations for different machine learning workloads.
 * @property initialInstanceCount Initial number of instances used for auto-scaling.
 * @property initialVariantWeight Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. If unspecified, it defaults to `1.0`.
 * @property instanceType The type of instance to start.
 * @property modelDataDownloadTimeoutInSeconds The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant. Valid values between `60` and `3600`.
 * @property modelName The name of the model to use.
 * @property routingConfigs Sets how the endpoint routes incoming traffic. See routing_config below.
 * @property serverlessConfig Specifies configuration for how an endpoint performs asynchronous inference.
 * @property variantName The name of the variant. If omitted, this provider will assign a random, unique name.
 * @property volumeSizeInGb The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Valid values between `1` and `512`.
 */
public data class EndpointConfigurationProductionVariant(
    public val acceleratorType: String? = null,
    public val containerStartupHealthCheckTimeoutInSeconds: Int? = null,
    public val coreDumpConfig: EndpointConfigurationProductionVariantCoreDumpConfig? = null,
    public val enableSsmAccess: Boolean? = null,
    public val inferenceAmiVersion: String? = null,
    public val initialInstanceCount: Int? = null,
    public val initialVariantWeight: Double? = null,
    public val instanceType: String? = null,
    public val modelDataDownloadTimeoutInSeconds: Int? = null,
    public val modelName: String,
    public val routingConfigs: List<EndpointConfigurationProductionVariantRoutingConfig>? = null,
    public val serverlessConfig: EndpointConfigurationProductionVariantServerlessConfig? = null,
    public val variantName: String? = null,
    public val volumeSizeInGb: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationProductionVariant): EndpointConfigurationProductionVariant = EndpointConfigurationProductionVariant(
            acceleratorType = javaType.acceleratorType().map({ args0 -> args0 }).orElse(null),
            containerStartupHealthCheckTimeoutInSeconds = javaType.containerStartupHealthCheckTimeoutInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            coreDumpConfig = javaType.coreDumpConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationProductionVariantCoreDumpConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableSsmAccess = javaType.enableSsmAccess().map({ args0 -> args0 }).orElse(null),
            inferenceAmiVersion = javaType.inferenceAmiVersion().map({ args0 -> args0 }).orElse(null),
            initialInstanceCount = javaType.initialInstanceCount().map({ args0 -> args0 }).orElse(null),
            initialVariantWeight = javaType.initialVariantWeight().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            modelDataDownloadTimeoutInSeconds = javaType.modelDataDownloadTimeoutInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            modelName = javaType.modelName(),
            routingConfigs = javaType.routingConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationProductionVariantRoutingConfig.Companion.toKotlin(args0)
                })
            }),
            serverlessConfig = javaType.serverlessConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationProductionVariantServerlessConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            variantName = javaType.variantName().map({ args0 -> args0 }).orElse(null),
            volumeSizeInGb = javaType.volumeSizeInGb().map({ args0 -> args0 }).orElse(null),
        )
    }
}
