@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property routingStrategy Sets how the endpoint routes incoming traffic. Valid values are `LEAST_OUTSTANDING_REQUESTS` and `RANDOM`. `LEAST_OUTSTANDING_REQUESTS` routes requests to the specific instances that have more capacity to process them. `RANDOM` routes each request to a randomly chosen instance.
 */
public data class EndpointConfigurationProductionVariantRoutingConfig(
    public val routingStrategy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationProductionVariantRoutingConfig): EndpointConfigurationProductionVariantRoutingConfig =
            EndpointConfigurationProductionVariantRoutingConfig(
                routingStrategy = javaType.routingStrategy(),
            )
    }
}
