@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationS3Uri The Amazon S3 bucket to send the core dump to.
 * @property kmsKeyId The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the core dump data at rest using Amazon S3 server-side encryption.
 */
public data class EndpointConfigurationShadowProductionVariantCoreDumpConfig(
    public val destinationS3Uri: String,
    public val kmsKeyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationShadowProductionVariantCoreDumpConfig): EndpointConfigurationShadowProductionVariantCoreDumpConfig =
            EndpointConfigurationShadowProductionVariantCoreDumpConfig(
                destinationS3Uri = javaType.destinationS3Uri(),
                kmsKeyId = javaType.kmsKeyId(),
            )
    }
}
