@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maxConcurrency The maximum number of concurrent invocations your serverless endpoint can process. Valid values are between `1` and `200`.
 * @property memorySizeInMb The memory size of your serverless endpoint. Valid values are in 1 GB increments: `1024` MB, `2048` MB, `3072` MB, `4096` MB, `5120` MB, or `6144` MB.
 * @property provisionedConcurrency The amount of provisioned concurrency to allocate for the serverless endpoint. Should be less than or equal to `max_concurrency`. Valid values are between `1` and `200`.
 */
public data class EndpointConfigurationShadowProductionVariantServerlessConfig(
    public val maxConcurrency: Int,
    public val memorySizeInMb: Int,
    public val provisionedConcurrency: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationShadowProductionVariantServerlessConfig): EndpointConfigurationShadowProductionVariantServerlessConfig =
            EndpointConfigurationShadowProductionVariantServerlessConfig(
                maxConcurrency = javaType.maxConcurrency(),
                memorySizeInMb = javaType.memorySizeInMb(),
                provisionedConcurrency = javaType.provisionedConcurrency().map({ args0 -> args0 }).orElse(null),
            )
    }
}
