@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumBatchSize Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value must be between 5% to 50% of the variant's total instance count. See Maximum Batch Size.
 * @property maximumExecutionTimeoutInSeconds The time limit for the total deployment. Exceeding this limit causes a timeout. Valid values are between `600` and `14400`.
 * @property rollbackMaximumBatchSize Batch size for rollback to the old endpoint fleet. Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback. See Rollback Maximum Batch Size.
 * @property waitIntervalInSeconds The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet. Valid values are between `0` and `3600`.
 */
public data class EndpointDeploymentConfigRollingUpdatePolicy(
    public val maximumBatchSize: EndpointDeploymentConfigRollingUpdatePolicyMaximumBatchSize,
    public val maximumExecutionTimeoutInSeconds: Int? = null,
    public val rollbackMaximumBatchSize: EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSize? = null,
    public val waitIntervalInSeconds: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointDeploymentConfigRollingUpdatePolicy): EndpointDeploymentConfigRollingUpdatePolicy = EndpointDeploymentConfigRollingUpdatePolicy(
            maximumBatchSize = javaType.maximumBatchSize().let({ args0 ->
                com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfigRollingUpdatePolicyMaximumBatchSize.Companion.toKotlin(args0)
            }),
            maximumExecutionTimeoutInSeconds = javaType.maximumExecutionTimeoutInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            rollbackMaximumBatchSize = javaType.rollbackMaximumBatchSize().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSize.Companion.toKotlin(args0)
                })
            }).orElse(null),
            waitIntervalInSeconds = javaType.waitIntervalInSeconds(),
        )
    }
}
